<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;

class ResetBiodataTable extends BaseCommand
{
    protected $group = 'Database';
    protected $name = 'db:reset-biodata';
    protected $description = 'Drops the biodata table.';

    public function run(array $params)
    {
        $db = \Config\Database::connect();
        $forge = \Config\Database::forge();

        try {
            if ($db->tableExists('biodata')) {
                $forge->dropTable('biodata', true);
                CLI::write("Table 'biodata' dropped.", 'green');
            } else {
                CLI::write("Table 'biodata' did not exist.", 'yellow');
            }
            if ($db->tableExists('activities')) {
                $forge->dropTable('activities', true);
                CLI::write("Table 'activities' dropped.", 'green');
            }
            if ($db->tableExists('education')) {
                $forge->dropTable('education', true);
                CLI::write("Table 'education' dropped.", 'green');
            }
        } catch (\Exception $e) {
            CLI::error($e->getMessage());
        }
    }
}
