<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\EducationModel;

class AdminEducation extends BaseController
{
    protected $educationModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Riwayat Pendidikan',
            'education' => $this->educationModel->orderBy('start_year', 'DESC')->findAll()
        ];
        return view('admin/education/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Pendidikan',
            'validation' => \Config\Services::validation()
        ];
        return view('admin/education/create', $data);
    }

    public function store()
    {
        if (
            !$this->validate([
                'institution' => 'required',
                'degree' => 'permit_empty', // Changed from required to permit_empty
                'start_year' => 'required|numeric'
            ])
        ) {
            return redirect()->to(base_url('admin/education/create'))->withInput();
        }

        $this->educationModel->save([
            'institution' => $this->request->getPost('institution'),
            'degree' => $this->request->getPost('degree'),
            'start_year' => $this->request->getPost('start_year'),
            'end_year' => $this->request->getPost('end_year'),
            'description' => $this->request->getPost('description'),
        ]);

        return redirect()->to(base_url('admin/education'))->with('success', 'Data pendidikan berhasil ditambahkan');
    }

    public function edit($id)
    {
        $education = $this->educationModel->find($id);
        if (!$education) {
            return redirect()->to(base_url('admin/education'))->with('error', 'Data tidak ditemukan');
        }

        $data = [
            'title' => 'Edit Pendidikan',
            'education' => $education,
            'validation' => \Config\Services::validation()
        ];
        return view('admin/education/edit', $data);
    }

    public function update($id)
    {
        if (
            !$this->validate([
                'institution' => 'required',
                'degree' => 'permit_empty',
                'start_year' => 'required|numeric'
            ])
        ) {
            return redirect()->to(base_url('admin/education/edit/' . $id))->withInput();
        }

        $this->educationModel->update($id, [
            'institution' => $this->request->getPost('institution'),
            'degree' => $this->request->getPost('degree'),
            'start_year' => $this->request->getPost('start_year'),
            'end_year' => $this->request->getPost('end_year'),
            'description' => $this->request->getPost('description'),
        ]);

        return redirect()->to(base_url('admin/education'))->with('success', 'Data pendidikan berhasil diperbarui');
    }

    public function delete($id)
    {
        $this->educationModel->delete($id);
        return redirect()->to(base_url('admin/education'))->with('success', 'Data pendidikan berhasil dihapus');
    }
}
