<?php 
namespace App\Controllers;

use App\Models\PegawaiModel;
use CodeIgniter\Exceptions\PageNotFoundException;

// Ganti BaseController menjadi Controller jika BaseController Anda tidak didefinisikan
// atau menggunakan CodeIgniter\Controller jika Anda tidak punya BaseController kustom
class News extends \CodeIgniter\Controller 
{
    // Fungsi index untuk menampilkan daftar semua pegawai yang 'published'
    public function index()
    {
        // Buat objek model pegawai
        $pegawaiModel = new PegawaiModel();

        /*
         Siapkan data untuk dikirim ke view.
         Penting: Nama variabel di sini harus SAMA dengan yang digunakan di VIEW (yaitu $newses).
         */
        $data['newses'] = $pegawaiModel->where('status', 'published')->findAll();
        
        // Asumsi variabel warna juga dibutuhkan oleh view news.php
        // Anda harus mendefinisikan variabel warna ini di controller:
        $data['color_d'] = '#007bff'; // Contoh nilai
        $data['color_c'] = '#dc3545'; // Contoh nilai
        $data['color_h'] = '#ffc107'; // Contoh nilai

        // Kirim data ke view 
        return view('news', $data); 
    }

    //------------------------------------------------------------

    // Fungsi untuk menampilkan detail satu data pegawai berdasarkan slug
    public function viewPegawai($slug)
    {
        $pegawaiModel = new PegawaiModel();
        
        // Ambil data pegawai berdasarkan slug dan status 'published'
        // Variabel di view detail Anda mungkin menggunakan $news, jadi kita ganti namanya
        $data['news'] = $pegawaiModel->where([ 
            'slug' => $slug,
            'status' => 'published'
        ])->first();

        // Tampilkan 404 error jika data tidak ditemukan
        if (!$data['news']) {
            throw PageNotFoundException::forPageNotFound();
        }

        // Kirim data ke view detail (asumsi view adalah 'news_detail')
        return view('news_detail', $data); 
    }
}