<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card border-0 shadow-sm" style="border-radius: 15px;">
            <div class="card-header bg-white border-bottom-0 py-3" style="border-radius: 15px 15px 0 0;">
                <h5 class="mb-0 fw-bold" style="color: var(--primary-color);">Edit Aktivitas</h5>
            </div>
            <div class="card-body p-4">
                <form action="<?= base_url('admin/activities/update/' . $activity['id']) ?>" method="post"
                    enctype="multipart/form-data">
                    <?= csrf_field() ?>

                    <div class="mb-3">
                        <label for="title" class="form-label fw-bold small text-muted text-uppercase">Judul
                            Aktivitas</label>
                        <input type="text"
                            class="form-control <?= ($validation->hasError('title')) ? 'is-invalid' : ''; ?>" id="title"
                            name="title" value="<?= old('title', $activity['title']) ?>" required>
                        <div class="invalid-feedback">
                            <?= $validation->getError('title'); ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="date_activity"
                                class="form-label fw-bold small text-muted text-uppercase">Tanggal</label>
                            <input type="date"
                                class="form-control <?= ($validation->hasError('date_activity')) ? 'is-invalid' : ''; ?>"
                                id="date_activity" name="date_activity"
                                value="<?= old('date_activity', $activity['date_activity']) ?>" required>
                            <div class="invalid-feedback">
                                <?= $validation->getError('date_activity'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="time_activity"
                                class="form-label fw-bold small text-muted text-uppercase">Waktu</label>
                            <input type="time"
                                class="form-control <?= ($validation->hasError('time_activity')) ? 'is-invalid' : ''; ?>"
                                id="time_activity" name="time_activity"
                                value="<?= old('time_activity', $activity['time_activity']) ?>" required>
                            <div class="invalid-feedback">
                                <?= $validation->getError('time_activity'); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description"
                            class="form-label fw-bold small text-muted text-uppercase">Deskripsi</label>
                        <textarea class="form-control" id="description" name="description"
                            rows="4"><?= old('description', $activity['description']) ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="image" class="form-label fw-bold small text-muted text-uppercase">Gambar</label>
                        <div class="mb-2">
                            <?php if ($activity['image']): ?>
                                <img src="<?= base_url('uploads/activities/' . $activity['image']) ?>" alt="Current Image"
                                    class="rounded" style="width: 100px; height: 100px; object-fit: cover;">
                                <div class="small text-muted mt-1">Gambar saat ini. Upload baru untuk mengganti.</div>
                            <?php else: ?>
                                <div class="small text-muted">Belum ada gambar.</div>
                            <?php endif; ?>
                        </div>
                        <input class="form-control <?= ($validation->hasError('image')) ? 'is-invalid' : ''; ?>"
                            type="file" id="image" name="image" accept="image/*">
                        <div class="invalid-feedback">
                            <?= $validation->getError('image'); ?>
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?= base_url('admin/activities') ?>" class="btn btn-light me-md-2"
                            style="color: #666;">Batal</a>
                        <button type="submit" class="btn text-white px-4"
                            style="background-color: var(--primary-color);">Simpan Perubahan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>