<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="card border-0 shadow-sm" style="border-radius: 15px;">
    <div class="card-header bg-white border-bottom-0 py-3 d-flex justify-content-between align-items-center"
        style="border-radius: 15px 15px 0 0;">
        <h5 class="mb-0 fw-bold" style="color: var(--primary-color);">Daftar Aktivitas</h5>
        <a href="<?= base_url('admin/activities/create') ?>" class="btn btn-sm text-white"
            style="background-color: var(--primary-color); border-radius: 8px;">
            <i class="fas fa-plus me-1"></i> Tambah Baru
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="bg-light text-muted">
                    <tr>
                        <th scope="col" width="5%">#</th>
                        <th scope="col" width="10%">Gambar</th>
                        <th scope="col" width="25%">Judul</th>
                        <th scope="col" width="20%">Waktu</th>
                        <th scope="col" width="25%">Deskripsi</th>
                        <th scope="col" width="15%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($activities)): ?>
                        <?php foreach ($activities as $key => $item): ?>
                            <tr>
                                <td><?= $key + 1 ?></td>
                                <td>
                                    <?php if ($item['image']): ?>
                                        <img src="<?= base_url('uploads/activities/' . $item['image']) ?>" alt="Img" class="rounded"
                                            style="width: 50px; height: 50px; object-fit: cover;">
                                    <?php else: ?>
                                        <span class="text-muted small">No Img</span>
                                    <?php endif; ?>
                                </td>
                                <td class="fw-bold text-dark"><?= esc($item['title']) ?></td>
                                <td class="text-muted small">
                                    <i class="far fa-clock me-1"></i>
                                    <?= date('d M Y', strtotime($item['date_activity'])) ?>,
                                    <?= date('H:i', strtotime($item['time_activity'])) ?>
                                </td>
                                <td class="text-muted small"><?= substr(esc($item['description']), 0, 50) ?>...</td>
                                <td>
                                    <a href="<?= base_url('admin/activities/edit/' . $item['id']) ?>"
                                        class="btn btn-sm btn-outline-primary border-0 rounded-circle" title="Edit">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a>
                                    <a href="<?= base_url('admin/activities/delete/' . $item['id']) ?>"
                                        onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')"
                                        class="btn btn-sm btn-outline-danger border-0 rounded-circle" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center py-4 text-muted">Belum ada data aktivitas.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?= $this->endSection() ?>