<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="row g-4">
    <!-- Statistic 1: Activities -->
    <div class="col-md-4">
        <div class="card border-0 shadow-sm p-3 h-100" style="border-radius: 15px;">
            <div class="card-body d-flex align-items-center">
                <div class="flex-shrink-0 me-3">
                    <div
                        style="width: 50px; height: 50px; border-radius: 12px; background: rgba(250, 174, 43, 0.2); display: flex; align-items: center; justify-content: center; color: var(--accent-color);">
                        <i class="fas fa-calendar-check fa-lg"></i>
                    </div>
                </div>
                <div>
                    <h6 class="card-subtitle mb-1 text-muted">Total Aktivitas</h6>
                    <h3 class="card-title mb-0 fw-bold"><?= $count_activities ?? 0 ?></h3>
                </div>
            </div>
            <div class="card-footer bg-transparent border-0 pt-0">
                <a href="<?= base_url('admin/activities') ?>" class="text-decoration-none small"
                    style="color: var(--primary-color);">Kelola Aktivitas <i class="fas fa-arrow-right ms-1"></i></a>
            </div>
        </div>
    </div>

    <!-- Statistic 2: Education -->
    <div class="col-md-4">
        <div class="card border-0 shadow-sm p-3 h-100" style="border-radius: 15px;">
            <div class="card-body d-flex align-items-center">
                <div class="flex-shrink-0 me-3">
                    <div
                        style="width: 50px; height: 50px; border-radius: 12px; background: rgba(100, 92, 85, 0.2); display: flex; align-items: center; justify-content: center; color: var(--primary-color);">
                        <i class="fas fa-graduation-cap fa-lg"></i>
                    </div>
                </div>
                <div>
                    <h6 class="card-subtitle mb-1 text-muted">Riwayat Pendidikan</h6>
                    <h3 class="card-title mb-0 fw-bold"><?= $count_education ?? 0 ?></h3>
                </div>
            </div>
            <div class="card-footer bg-transparent border-0 pt-0">
                <a href="<?= base_url('admin/education') ?>" class="text-decoration-none small"
                    style="color: var(--primary-color);">Kelola Pendidikan <i class="fas fa-arrow-right ms-1"></i></a>
            </div>
        </div>
    </div>

    <!-- Welcome Widget -->
    <div class="col-12">
        <div class="card border-0 shadow-sm p-4 text-white"
            style="border-radius: 20px; background: linear-gradient(135deg, #645c55 0%, #4e4640 100%);">
            <div class="card-body">
                <h3 class="fw-bold mb-2">Selamat Datang di Panel Admin</h3>
                <p style="opacity: 0.9;">Anda dapat mengelola konten website portofolio Anda dari sini. Gunakan menu
                    sidebar untuk menavigasi ke bagian manajemen Biodata, Pendidikan, atau Aktivitas.</p>

                <div class="mt-4">
                    <a href="<?= base_url('/') ?>" target="_blank" class="btn btn-light rounded-pill px-4 fw-bold"
                        style="color: var(--primary-color);">
                        <i class="fas fa-external-link-alt me-2"></i> Lihat Website
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>