<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="card border-0 shadow-sm" style="border-radius: 15px;">
    <div class="card-header bg-white border-bottom-0 py-3 d-flex justify-content-between align-items-center"
        style="border-radius: 15px 15px 0 0;">
        <h5 class="mb-0 fw-bold" style="color: var(--primary-color);">Riwayat Pendidikan</h5>
        <a href="<?= base_url('admin/education/create') ?>" class="btn btn-sm text-white"
            style="background-color: var(--primary-color); border-radius: 8px;">
            <i class="fas fa-plus me-1"></i> Tambah Baru
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="bg-light text-muted">
                    <tr>
                        <th>Institusi</th>
                        <th>Gelar</th>
                        <th>Tahun</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($education)): ?>
                        <?php foreach ($education as $item): ?>
                            <tr>
                                <td class="fw-bold"><?= esc($item['institution']) ?></td>
                                <td><?= esc($item['degree']) ?></td>
                                <td><?= esc($item['start_year']) ?> -
                                    <?= $item['end_year'] ? esc($item['end_year']) : 'Sekarang' ?>
                                </td>
                                <td>
                                    <a href="<?= base_url('admin/education/edit/' . $item['id']) ?>"
                                        class="btn btn-sm btn-outline-primary me-1" title="Edit">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a>
                                    <a href="<?= base_url('admin/education/delete/' . $item['id']) ?>"
                                        class="btn btn-sm btn-outline-danger"
                                        onclick="return confirm('Yakin ingin menghapus data ini?')" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted">Belum ada data.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?= $this->endSection() ?>