<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - SJ Portfolio</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Google Fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Poppins:wght@300;400;500;600&display=swap"
        rel="stylesheet">

    <style>
        :root {
            --primary-color: #645c55;
            --accent-color: #faae2b;
            --bg-color: #f8f9fa;
            --sidebar-width: 260px;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--bg-color);
            overflow-x: hidden;
        }

        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            background: #fff;
            box-shadow: 2px 0 20px rgba(0, 0, 0, 0.05);
            z-index: 1000;
            transition: all 0.3s;
        }

        .sidebar-header {
            padding: 30px;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
            /* justify-content: center; */
        }

        .sidebar-brand {
            font-family: 'Playfair Display', serif;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-color);
            text-decoration: none;
        }

        .sidebar-menu {
            padding: 20px 0;
            list-style: none;
            margin: 0;
        }

        .menu-item {
            margin-bottom: 5px;
        }

        .menu-link {
            display: flex;
            align-items: center;
            padding: 12px 30px;
            color: #666;
            text-decoration: none;
            font-size: 0.95rem;
            border-left: 4px solid transparent;
            transition: all 0.2s;
        }

        .menu-link:hover,
        .menu-link.active {
            background: #fdfdfd;
            color: var(--accent-color);
            border-left-color: var(--accent-color);
        }

        .menu-link i {
            width: 25px;
            margin-right: 10px;
            font-size: 1.1rem;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 30px;
            transition: all 0.3s;
        }

        /* Topbar */
        .topbar {
            background: transparent;
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .page-title {
            font-family: 'Playfair Display', serif;
            font-weight: 700;
            color: var(--primary-color);
            margin: 0;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--accent-color);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                margin-left: calc(var(--sidebar-width) * -1);
            }

            .sidebar.active {
                margin-left: 0;
            }

            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>

<body>

    <!-- Sidebar -->
    <nav class="sidebar">
        <div class="sidebar-header">
            <a href="<?= base_url('admin/dashboard') ?>" class="sidebar-brand">
                SJ Admin<span style="color: var(--accent-color);">.</span>
            </a>
        </div>
        <ul class="sidebar-menu">
            <li class="menu-item">
                <a href="<?= base_url('admin/dashboard') ?>"
                    class="menu-link <?= uri_string() == 'admin/dashboard' ? 'active' : '' ?>">
                    <i class="fas fa-th-large"></i> Dashboard
                </a>
            </li>
            <li class="menu-header"
                style="padding: 20px 30px 10px; font-size: 0.75rem; text-transform: uppercase; color: #aaa; letter-spacing: 1px;">
                Manajemen Konten</li>
            <li class="menu-item">
                <a href="<?= base_url('admin/biodata') ?>"
                    class="menu-link <?= strpos(uri_string(), 'admin/biodata') !== false ? 'active' : '' ?>">
                    <i class="fas fa-user-circle"></i> Biodata / CV
                </a>
            </li>
            <li class="menu-item">
                <a href="<?= base_url('admin/education') ?>"
                    class="menu-link <?= strpos(uri_string(), 'admin/education') !== false ? 'active' : '' ?>">
                    <i class="fas fa-graduation-cap"></i> Riwayat Pendidikan
                </a>
            </li>
            <li class="menu-item">
                <a href="<?= base_url('admin/activities') ?>"
                    class="menu-link <?= strpos(uri_string(), 'admin/activities') !== false ? 'active' : '' ?>">
                    <i class="fas fa-calendar-check"></i> Aktivitas Harian
                </a>
            </li>

            <li class="menu-header"
                style="padding: 20px 30px 10px; font-size: 0.75rem; text-transform: uppercase; color: #aaa; letter-spacing: 1px;">
                System</li>
            <li class="menu-item">
                <a href="<?= base_url('admin/logout') ?>" class="menu-link text-danger">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </li>
        </ul>
    </nav>

    <!-- Main Content -->
    <div class="main-content">
        <div class="topbar">
            <h2 class="page-title"><?= $title ?? 'Dashboard' ?></h2>
            <div class="user-profile">
                <span>Hello, <strong>Admin</strong></span>
                <div class="user-avatar">A</div>
            </div>
        </div>

        <!-- Validation Errors -->
        <?php if (session()->has('errors')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul>
                    <?php foreach (session('errors') as $error): ?>
                        <li><?= $error ?></li>
                    <?php endforeach; ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if (session()->has('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= session('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if (session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i> <?= session('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Content Injection -->
        <?= $this->renderSection('content') ?>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Optional: Toggle Sidebar for Mobile
    </script>
</body>

</html>