<?php
// ===============================
// AREA UNTUK MENGUBAH PALET WARNA (SOFT VERSION)
// ===============================

// $color_d: Warna Latar Belakang Navbar
$color_d = '#ffffff'; // Putih bersih

// $color_h: Warna Aksen (Hover & Active)
$color_h = '#666666'; // Abu-abu medium

// $color_accent: Warna lembut untuk background hover
$color_accent = '#f8f9fa';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Siti Julaeha</title>

    <style>
        /* 🎨 Navbar Premium Style */
        .navbar-madani {
            background-color: rgba(255, 255, 255, 0.95) !important;
            backdrop-filter: blur(10px);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            padding: 15px 0;
            transition: all 0.3s ease;
        }

        .navbar-madani .navbar-brand {
            font-weight: 800;
            color: #645c55 !important;
            letter-spacing: 1px;
            font-size: 1.5rem;
            font-family: 'Playfair Display', serif;
        }

        /* Menu Items (Icons) */
        .navbar-madani .nav-item {
            margin: 0 5px;
        }

        .navbar-madani .nav-link {
            color: #645c55 !important;
            /* Dark Brown */
            font-weight: 500;
            padding: 10px 18px !important;
            border-radius: 50px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Hover Effect for Icons */
        .navbar-madani .nav-link:hover {
            color: #faae2b !important;
            /* Orange Highlight */
            background-color: rgba(250, 174, 43, 0.1);
            transform: translateY(-2px);
        }

        /* Active State */
        .navbar-madani .nav-item.active .nav-link {
            color: #faae2b !important;
            background-color: rgba(250, 174, 43, 0.15);
            font-weight: 700;
        }

        /* Login Button Style */
        .navbar-madani .btn-login-nav {
            background: linear-gradient(135deg, #645c55 0%, #4e4640 100%);
            color: #fff !important;
            padding: 8px 25px !important;
            border-radius: 50px;
            box-shadow: 0 4px 15px rgba(100, 92, 85, 0.3);
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }

        .navbar-madani .btn-login-nav:hover {
            background: linear-gradient(135deg, #faae2b 0%, #e59a1f 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(250, 174, 43, 0.4);
            color: #fff !important;
            /* Ensure text stays white */
        }
    </style>
</head>

<body>

    <nav class="navbar navbar-expand-lg navbar-light navbar-madani sticky-top">
        <div class="container-fluid px-lg-5">
            <!-- Brand Logotype -->
            <a class="navbar-brand" href="<?= base_url() ?>">
                SJ<span style="color: #faae2b;">.</span>
            </a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav"
                style="border: none; outline: none;">
                <span class="" style="font-size: 1.5rem; color: #645c55;"><i class="fas fa-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav mr-auto align-items-center"> <!-- Left Side Icons -->
                    <li class="nav-item <?= uri_string() == '' ? 'active' : '' ?>">
                        <a class="nav-link" href="<?= base_url('/') ?>" title="Beranda"><i class="fas fa-home"
                                style="font-size: 1.2rem;"></i></a>
                    </li>
                    <li class="nav-item <?= uri_string() == 'biodata' ? 'active' : '' ?>">
                        <a class="nav-link" href="<?= base_url('biodata') ?>" title="Biodata"><i class="fas fa-user"
                                style="font-size: 1.2rem;"></i></a>
                    </li>
                    <li class="nav-item <?= uri_string() == 'education' ? 'active' : '' ?>">
                        <a class="nav-link" href="<?= base_url('education') ?>" title="Pendidikan"><i
                                class="fas fa-graduation-cap" style="font-size: 1.2rem;"></i></a>
                    </li>
                    <li class="nav-item <?= uri_string() == 'aktivitas' ? 'active' : '' ?>">
                        <a class="nav-link" href="<?= base_url('aktivitas') ?>" title="Aktivitas"><i
                                class="fas fa-calendar-alt" style="font-size: 1.2rem;"></i></a>
                    </li>
                </ul>
                <ul class="navbar-nav align-items-center"> <!-- Right Side Button -->
                    <li class="nav-item">
                        <a class="nav-link btn-login-nav" href="<?= base_url('admin/login') ?>"
                            style="margin-left: 10px;">Login</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

</body>

</html>