<?php
$color_d = '#00473e';   // Headline
$color_h = '#faae2b';   // Highlight
$color_c = '#ffa8ba';   // Secondary

$color_text = '#475d5b';
$color_stroke = '#00332c';
?>

<?= $this->extend('layout/post_layout') ?>
<?= $this->section('content') ?>

<style>
    /* --- Container diperkecil --- */
    .news-list-container {
        padding-top: 40px;
        padding-bottom: 60px;
        max-width: 880px; /* diperkecil dari default 1140px */
        margin: auto;
    }

    /* --- CARD --- */
    .news-card {
        border-radius: 16px;
        border: none;
        border-right: 8px solid <?= $color_h ?>;
        background: #ffffff;
        margin-bottom: 32px;

        /* Shadow premium */
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);

        transition: 0.4s cubic-bezier(.22,.61,.36,1);
        overflow: hidden;
    }
    .news-card:hover {
        transform: translateY(-8px) scale(1.015);
        border-right-color: <?= $color_d ?>;
        box-shadow: 0 16px 36px rgba(0, 71, 62, 0.20);
    }

    .news-card .card-body {
        padding: 32px;
    }

    /* --- JUDUL PEGAWAI --- */
    .news-card h5 a {
        color: <?= $color_d ?>;
        font-weight: 800;
        text-decoration: none;
        letter-spacing: 0.6px;
        font-size: 1.32rem;
        transition: 0.3s ease;
        display: block;
    }
    .news-card h5 a:hover {
        color: <?= $color_h ?>;
        transform: translateX(6px);
    }

    /* --- PARAGRAF --- */
    .news-card p {
        color: <?= $color_text ?>;
        font-size: 1.02rem;
        line-height: 1.6rem;
        margin-bottom: 20px;
    }

    /* --- READ MORE --- */
    .read-more-link {
        color: <?= $color_h ?>;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 0.82rem;
        letter-spacing: 1px;
        text-decoration: none;
        border-bottom: 2px solid <?= $color_h ?>;
        padding-bottom: 3px;
        transition: 0.3s ease;
    }
    .read-more-link:hover {
        color: <?= $color_d ?>;
        border-bottom-color: <?= $color_d ?>;
        padding-left: 5px;
    }

    /* --- HEADER UTAMA --- */
    .news-list-container h2 {
        font-weight: 900;
        color: <?= $color_d ?>;
        border-bottom: 3px dashed <?= $color_c ?>;
        padding-bottom: 12px;
        margin-bottom: 38px;
        letter-spacing: 0.8px;
        font-size: 2rem;
        text-align: center;
    }

    .news-list-container h2 i {
        color: <?= $color_h ?>;
        margin-right: 10px;
    }
</style>

<div class="news-list-container">
    <h2>
        <i class="fas fa-newspaper"></i>
        Data Pegawai
    </h2>

    <?php foreach ($newses as $news) : ?>
        <div class="card news-card">
            <div class="card-body">
                <h5>
                    <a href="/news/<?= $news['slug'] ?>">
                        <?= $news['nama_pegawai'] ?>
                    </a>
                </h5>

                <p><?= substr($news['content'], 0, 150) ?>...</p>

                <a href="/news/<?= $news['slug'] ?>" class="read-more-link">
                    Baca Selengkapnya <i class="fas fa-arrow-right ms-1"></i>
                </a>
            </div>
        </div>
    <?php endforeach ?>
</div>

<?= $this->endSection() ?>
