<?php
// Warna diambil dari referensi gambar
$color_bg_left = '#e3ddd5'; // Beige/Cream
$color_bg_right = '#645c55'; // Dark Brown/Taupe
$color_text_light = '#e3ddd5'; // Text on dark background
$color_text_dark = '#645c55'; // Text on light background
?>

<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<!-- Load Google Fonts & FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link
    href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;0,600;0,700;1,400&family=Montserrat:wght@300;400;500;600&display=swap"
    rel="stylesheet">

<style>
    /* Reset & Overrides */
    body {
        margin: 0;
        padding: 0;
        overflow-x: hidden;
        background-color:
            <?= $color_bg_left ?>
        ;
    }

    /* Hide default jumbotron if it exists in layout */
    .jumbotron-company-header {
        display: none !important;
    }

    /* Main Layout */
    .hero-container {
        display: flex;
        flex-wrap: wrap;
        min-height: 100vh;
        width: 100%;
    }

    /* Left Section (Image Side) */
    .left-section {
        flex: 0 0 40%;
        max-width: 40%;
        background-color:
            <?= $color_bg_left ?>
        ;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        padding-top: 50px;
        /* Space for aesthetic */
    }

    /* Arch Image Wrapper */
    .arch-wrapper {
        width: 80%;
        max-width: 400px;
        height: 75vh;
        background-color: #ccc;
        border-top-left-radius: 200px;
        border-top-right-radius: 200px;
        overflow: hidden;
        position: relative;
        box-shadow: -10px 0 0 rgba(0, 0, 0, 0.05);
        /* Subtle shadow on left */
    }

    .arch-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        /* Positioning logic: assuming the provided image might be the full design, 
           we try to center or crop. If it's a model photo, this works well. */
        object-position: center top;
    }

    /* Right Section (Content Side) */
    .right-section {
        flex: 0 0 60%;
        max-width: 60%;
        background-color:
            <?= $color_bg_right ?>
        ;
        color:
            <?= $color_text_light ?>
        ;
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 4rem 6rem;
        position: relative;
    }

    /* Top Right Tag */
    .top-pill {
        position: absolute;
        top: 40px;
        right: 0;
        background-color:
            <?= $color_bg_left ?>
        ;
        color:
            <?= $color_text_dark ?>
        ;
        padding: 12px 40px 12px 25px;
        border-top-left-radius: 30px;
        border-bottom-left-radius: 30px;
        font-family: 'Montserrat', sans-serif;
        font-weight: 600;
        font-size: 0.9rem;
        letter-spacing: 0.5px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    /* Typography */
    .main-heading {
        font-family: 'Playfair Display', serif;
        font-size: 4rem;
        font-weight: 700;
        line-height: 0.95;
        margin-bottom: 2rem;
        text-transform: uppercase;
        color:
            <?= $color_text_light ?>
        ;
        letter-spacing: 2px;
    }

    .subtitle-badge {
        display: inline-block;
        background-color:
            <?= $color_bg_left ?>
        ;
        color:
            <?= $color_text_dark ?>
        ;
        padding: 15px 35px;
        font-family: 'Playfair Display', serif;
        font-size: 1.1rem;
        font-weight: 700;
        letter-spacing: 1px;
        text-transform: uppercase;
        margin-bottom: 4rem;
        width: fit-content;
    }

    /* Socials */
    .social-area {
        display: flex;
        align-items: center;
        gap: 20px;
    }

    .social-icon-box {
        background-color: transparent;
        /* Or border box if needed */
        color:
            <?= $color_text_light ?>
        ;
        font-size: 1.6rem;
        transition: transform 0.3s;
    }

    .social-icon-box:hover {
        transform: translateY(-3px);
    }

    .social-handle {
        font-family: 'Montserrat', sans-serif;
        font-size: 1rem;
        font-weight: 400;
        margin-left: 10px;
        opacity: 0.9;
    }

    /* Decorative Element Left Bottom (Half Circle) */
    .decor-circle {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 150px;
        height: 150px;
        background-color:
            <?= $color_text_dark ?>
        ;
        /* Dark brown matches right side */
        border-top-right-radius: 100%;
        z-index: 10;
        display: none;
        /* Optional: active if desired */
    }

    /* RESPONSIVE */
    @media (max-width: 991px) {
        .hero-container {
            flex-direction: column;
        }

        .left-section {
            flex: auto;
            max-width: 100%;
            height: 500px;
            padding-bottom: 0;
            align-items: flex-end;
            /* Align image bottom */
        }

        .arch-wrapper {
            height: 400px;
            margin-bottom: 0;
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
        }

        .right-section {
            flex: auto;
            max-width: 100%;
            padding: 3rem 2rem;
            text-align: center;
            align-items: center;
        }

        .top-pill {
            top: 20px;
        }

        .main-heading {
            font-size: 3.5rem;
        }

        .subtitle-badge {
            margin-bottom: 2rem;
        }
    }
</style>

<div class="hero-container">
    <div class="left-section">
        <!-- Rounded Decoration from design reference (dark shape at bottom left) -->
        <svg style="position: absolute; bottom: 0; left: 0; width: 150px; height: 150px; fill: <?= $color_bg_right ?>;"
            viewBox="0 0 100 100" preserveAspectRatio="none">
            <path d="M0,100 L0,0 Q100,0 100,100 Z" transform="rotate(-90 50 50) translate(-50 50) scale(2)" />
            <!-- Simplified: Just use a div border radius -->
        </svg>
        <div
            style="position: absolute; bottom: 0; left: 0; width: 120px; height: 120px; background-color: <?= $color_bg_right ?>; border-top-right-radius: 100%;">
        </div>

        <div class="arch-wrapper">
            <!-- Using the user provided image URL -->
            <img src="https://i.pinimg.com/1200x/7e/a0/ab/7ea0abc784479204db3118a172c31a19.jpg" alt="Madani Yatsi Model"
                class="arch-image">
        </div>
    </div>

    <div class="right-section">
        <a href="#" class="top-pill">
            @sjulaaeha
        </a>

        <h1 class="main-heading">
            PORTOFOLIO
        </h1>

        <a href="<?= base_url('biodata') ?>" class="subtitle-badge" style="text-decoration: none;">
            SITI JULAEHA
        </a>

        <div class="social-area">
            <a href="https://www.instagram.com/sjulaaeha/" target="_blank" class="social-icon-box"><i
                    class="fab fa-instagram"></i></a>
            <a href="https://www.linkedin.com/in/siti-julaeha-b4a219329" target="_blank" class="social-icon-box"><i
                    class="fab fa-linkedin"></i></a>
            <a href="https://github.com/sjulaaeha" target="_blank" class="social-icon-box"><i
                    class="fab fa-github"></i></a>

        </div>
    </div>
</div>

<?= $this->endSection() ?>